    <?php
    /*
    SOURCE: http://docs.moodle.org/22/en/Aiken_format
     
    a. The question must be all on one line.
    b. Each answer must start with a single uppercase letter,
    c. followed by a period '.' or a bracket ')', then a space.
    d. The answer line must immediately follow, starting with "ANSWER: " (NOTE the space after the colon)
    and then giving the appropriate letter.
     
    NOTE: script dibawah mengabaikan syarat b
    */
    function parseAikenFormat($file)
    {
            $result = array();
     
            if(!is_readable($file))
                    return FALSE;
     
            $lines = file($file);
            if(!is_array($lines))
                    return FALSE;
     
            $start = true;
            $question = array();
            foreach($lines as $line)
            {
                    $line = trim($line);
                    if($line == "") continue;
     
                    if($start)
                    {
                            $question = array(
                                    'question' => $line, // syarat a
                                    'options' => array()
                            );
                            $start = false;
                    }
                    else if(preg_match("/^ANSWER:\s{1}/", $line))
                    {
                             //syarat d, starting with "ANSWER: "
                            $answer = trim(preg_replace("/^ANSWER:\s{1}/", '', $line));
                            $question['answer'] = $answer;
                            $result[] = $question;
                            $start = true;
                    }
                    else
                    {
                            $options = explode(' ', $line, 2);
                            list($opt, $optText) = $options;
                            // syarat c '.' atau ')'
                            $opt = trim(preg_replace("/\.|\)/", '', $opt)); 
                            $question['options'][$opt] = trim($optText);
                    }
            }
     
            return $result;
    }
     
     

?>