<!DOCTYPE html>
<html lang="en">
<head>
  <?php require_once "cls/config.php"; ?>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <link href="img/logo/logo.png" rel="icon">
  <title>Quantum Computer Based Test (QCBT) <?php echo $nama_sekolah ?> - Login</title>
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css">
  <link href="css/ruang-admin.css" rel="stylesheet">
  <link rel="icon" href="favicon.ico" type="image/x-icon" />
  <style>
  	html {
		    width: 100vw;
		}
	.hidden{
  		display:none;
  	}
  	
	@media (min-width:768px) {
	  .container-login {
	  	width: 550px;
	  	height: 600px;
	    margin: auto;
	    
	  }
	}
  </style>
</head>

<body class="bg-gradient-login">
  <!-- Login Content -->
  <div class="container-login">
    <div class="row justify-content-center">
      <div class="col-xl-10 col-lg-12 col-md-9">
        <div class="card shadow-sm my-5">
          <div class="card-body p-0">
            <div class="row">
              <div class="col-lg-12">
                <div class="login-form">
                  <div class="text-center">
                  	<img src="img/logoQCBT.png" width="100%" />                    
                  </div>
				  <hr />
                  <h5 class="font-weight-bold text-center mb-n2 text-warning">
                  	Maaf Anda harus menggunakan Exam Browser Yang Sesuai!
                  </h5>
                  <div class="text-center text-sm mt-4">Silahkan hubungi Proktor</div>
  				  <hr/>
      			  <div class="font-weight-bold text-center mt-2 mb-2 text-info" style="font-size:small">Untuk Penggunana SEB (Safe Exam Browser)<br/>Silahkan klik tombol START di bawah</div>
                  <center>
  						<a href="<?php echo $_SEB_URL . strtoupper($kode_sekolah) ?>.seb"><img width="100" src="img/START.png" /></a>
  				  </center>
                  <hr />  
  				  <div class="row text-center">
  						<div class="col-4">
	  						<a href= "https://drive.google.com/file/d/1onc7ARUZtAazxonE-dJy_RPZAwZ6nol3/view?usp=sharing"><img class="img-fluid"  src="img/play.png" /></a>  
  						</div>
   						<div class="col-4">
	  						<a href= "https://apps.apple.com/us/app/safeexambrowser/id1155002964"><img class="img-fluid" src="img/appstore.png" /></a>  
  						</div>
   						<div class="col-4">
	  						<a href= "https://sourceforge.net/projects/seb/files/seb/SEB_3.8.0/SEB_3.8.0.742_SetupBundle.exe/download"><img class="img-fluid" src="img/windows.png" /></a>  
  						</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Login Content -->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
  <script src="js/ruang-admin.min.js"></script>
  <script src="js/bootbox/bootbox.min.js"></script>
  <script>
		
		
  		$(".toggle-password").click(function() {

		  $(this).toggleClass("fa-eye-slash fa-eye");
		  var input = $($(this).attr("toggle"));
		  if (input.attr("type") == "password") {
		    input.attr("type", "text");
		  } else {
		    input.attr("type", "password");
		  }
		});
      $(".formIsi").submit( function() {//alert('submit');        
    	loading('Tunggu, data sedang diproses!...');
        var post_data = $(this).serialize(); 
        var form_action = $(this).attr("action");
        var form_method = $(this).attr("method");//alert(post_data);
        $("#submit").hide('slow');
        sendAJAX(form_method, form_action, post_data);
        return false;
    });    

	function redirectPage(url,secURL) {//
		if (secURL){
			$.post("cls/encodeURL.php",{normalURL:url}, function(result){
			    window.location.href=' '+result;
			});
			
		}else{//alert(url);
			window.location.href=' '+url;
		}
	}
	function loading(msg){
		bootbox.alert({ 
		    message: '<div class="text-center"><i class="fa fa-spin fa-spinner"></i> '+ msg  +'</div>', 
		    closeButton: false 
		})
	}
	
	function addAlert(msg,style='info',nexturl='', secURL=true){
		var logo;
		bootbox.hideAll();
		switch (style){
			case 'danger':
				logo='<i class="fas fa-times text-danger fa-4x"></i>'
				break;
			case 'success':
				logo='<i class="fas fa-check text-success fa-4x"></i>'
				break;
			case 'info':
				logo='<i class="fas fa-check text-info fa-4x"></i>'
				break;
			default:
				logo='<i class="fas fa-check text-info fa-4x"></i>'
		}
		if (nexturl!=''){
			bootbox.alert('<center class="text-'+style+'">'+logo + '<br />' + msg + '</center>', function(){			
				redirectPage(nexturl,secURL);
			});
		}else{
			bootbox.alert('<center class="text-'+style+'">'+logo + '<br />' + msg + '</center>',function(result){
				bootbox.hideAll();
			});			
		}
		
		
	}    
  	
  	function sendAJAX(form_method, form_action, post_data){
		$.ajax({
            type :form_method,
            url :form_action,
            cache :false,
            data :post_data,
            success : function(data) {
            	data=data.trim();
            	bootbox.hideAll();
            	if (data.substr(0,1)=='1'){
            		bootbox.hideAll();addAlert(data.substr(1,data.length-1),'success');
            		redirectPage("index.php");	  
            	}else if (data.substr(0,1)=='0'){
            		addAlert(data.substr(1,data.length-1),'danger',);        		
            	}else {
            		addAlert(data,'danger');
					$("#submit").show('slow');
				}	
      
            },
            error : function() {//alert('Error');
            	bootbox.hideAll();
            	addAlert("Kirim data eror !","danger");
            }
        });
	}

  </script>
</body>

</html>