<!DOCTYPE html>
<?php 
	session_start();
	require_once "cls/config.php" ;	
	if (ISSET($_SESSION['user_id']) && $_SESSION['user_id']!='' && $_SESSION['sta']>0){
		header('location:index.php');
	}
	
	if (ISSET($_GET['qcbt']) && trim($_GET['qcbt'])!='') $_COOKIE['qcbt']=trim($_GET['qcbt']); 
	
	$conFile=parse_ini_file("config.ini",true);
?>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <link href="img/logo/logo.png" rel="icon">
  <title>Quantum Computer Based Test (QCBT) <?php echo $nama_sekolah ?> - Login</title>
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css">
  <link href="css/ruang-admin.css" rel="stylesheet">
  <link rel="icon" href="favicon.ico" type="image/x-icon" />
  <style>
  	html {
		    width: 100vw;
		}
	.hidden{
  		display:none;
  	}
  	
	@media (min-width:768px) {
	  .container-login {
	  	width: 550px;
	  	height: 600px;
	    margin: auto;
	    
	  }
	}
  </style>
</head>

<body class="bg-gradient-login">
  <!-- Login Content -->
  <div class="container-login">
    <div class="row justify-content-center">
      <div class="col-xl-10 col-lg-12 col-md-9">
        <div class="card shadow-sm my-5">
          <div class="card-body p-0">
            <div class="row">
              <div class="col-lg-12">
                <div class="login-form">
                  <div class="text-center">
                  	<img src="img/logoQCBT.png" width="100%" />                    
                  </div>
				  <hr />
                  <h5 class="font-weight-bold text-center mb-n2 text-warning"><?php echo ($_JNS_SERVER=='SS')?$nama_sekolah:'SERVER PUSAT' ?></h5>
                  <hr />                  
                  <form class="user formIsi" method="post" action="scr/cek_ref.php?login" enctype="multipart/form-data" role="form">
                    <div class="form-group">
                      <input value="<?php echo $_GET['nik'] ?>" name="user_id" type="text" class="form-control" id="exampleInputEmail" aria-describedby="emailHelp" placeholder="Masukkan Username" required="">
                    </div>
                    <div class="input-group mb-3">
                      <input type="password" value="<?php echo $_GET['password'] ?>"  maxlength="50" name="password" id="password" class="form-control" id="exampleInputPassword" placeholder="Password" required="">
                      <span class="input-group-append"><i toggle="#password"  class="fa fa-eye field-icon toggle-password ml-n4 mt-3 text-gray-10" style="z-index: 1000;cursor: pointer;"></i></span>
                    </div>
                    <div class="form-group">
                    	<?php (count($_JENIS_QCBT)==1)? $show='hidden':$show=''; ?>
						<select name="qcbt" class="form-control <?php echo $show ?>" placeholder="Jenis QCBT" required>
						<?php
							
							foreach($_JENIS_QCBT as $key=>$value){
								echo '<option value="'.$key.'" '.(($_COOKIE['qcbt']==$key)?'selected':'').'>'.$value.'</option>';
							}
						
						?>
						</select>                      
                    </div>                                       
                    <div class="form-group">
                      <button class="btn btn-primary btn-block">Login</button>
                    </div>
                    <hr>
                    <div class="text-center mb-2" style="font-size: x-small" id="version"><?php echo $conFile['qcbt']['versi']; ?></div>
                    <div class="text-center">
                  		<img src="img/primatek.png" width="50%" />                    
                  	</div>
                    
                  </form>
                  
                  
                  <div class="text-center">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Login Content -->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
  <script src="js/ruang-admin.min.js"></script>
  <script src="js/bootbox/bootbox.min.js"></script>
  <script>
		
		
  		$(".toggle-password").click(function() {

		  $(this).toggleClass("fa-eye-slash fa-eye");
		  var input = $($(this).attr("toggle"));
		  if (input.attr("type") == "password") {
		    input.attr("type", "text");
		  } else {
		    input.attr("type", "password");
		  }
		});
      $(".formIsi").submit( function() {//alert('submit');        
    	loading('Tunggu, data sedang diproses!...');
        var post_data = $(this).serialize(); 
        var form_action = $(this).attr("action");
        var form_method = $(this).attr("method");//alert(post_data);
        $("#submit").hide('slow');
        sendAJAX(form_method, form_action, post_data);
        return false;
    });    

	function redirectPage(url,secURL) {//
		if (secURL){
			$.post("cls/encodeURL.php",{normalURL:url}, function(result){
			    window.location.href=' '+result;
			});
			
		}else{//alert(url);
			window.location.href=' '+url;
		}
	}
	function loading(msg){
		bootbox.alert({ 
		    message: '<div class="text-center"><i class="fa fa-spin fa-spinner"></i> '+ msg  +'</div>', 
		    closeButton: false 
		})
	}
	
	function addAlert(msg,style='info',nexturl='', secURL=true){
		var logo;
		bootbox.hideAll();
		switch (style){
			case 'danger':
				logo='<i class="fas fa-times text-danger fa-4x"></i>'
				break;
			case 'success':
				logo='<i class="fas fa-check text-success fa-4x"></i>'
				break;
			case 'info':
				logo='<i class="fas fa-check text-info fa-4x"></i>'
				break;
			default:
				logo='<i class="fas fa-check text-info fa-4x"></i>'
		}
		if (nexturl!=''){
			bootbox.alert('<center class="text-'+style+'">'+logo + '<br />' + msg + '</center>', function(){			
				redirectPage(nexturl,secURL);
			});
		}else{
			bootbox.alert('<center class="text-'+style+'">'+logo + '<br />' + msg + '</center>',function(result){
				bootbox.hideAll();
			});			
		}
		
		
	}    
  	
  	function sendAJAX(form_method, form_action, post_data){
		$.ajax({
            type :form_method,
            url :form_action,
            cache :false,
            data :post_data,
            success : function(data) {
            	data=data.trim();
            	bootbox.hideAll();
            	if (data.substr(0,1)=='1'){
            		bootbox.hideAll();addAlert(data.substr(1,data.length-1),'success');
            		redirectPage("index.php");	  
            	}else if (data.substr(0,1)=='0'){
            		addAlert(data.substr(1,data.length-1),'danger',);        		
            	}else {
            		addAlert(data,'danger');
					$("#submit").show('slow');
				}	
      
            },
            error : function() {//alert('Error');
            	bootbox.hideAll();
            	addAlert("Kirim data eror !","danger");
            }
        });
	}

  </script>
</body>

</html>